/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.certs;

import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.certs.CertMgtConstants;
import com.ibm.hwmca.fw.certs.CertUtils;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;

public class CertSignReq
implements CertMgtConstants {
    public static final int RETURN_OK = 0;
    public static final int RETURN_INVALID_NUM_OF_ARGS = 16;
    public static final int RETURN_EXCEPTION = 32;
    public static final int RETURN_INSUFFICIENT = 48;
    public static final int RETURN_EXTRANEOUS = 64;
    public static final int RETURN_UNKNOWN = 80;
    private static int INDEX_OF_LAST_FIXED_ARG = 9;
    private static final String TRACE_MASKD = "XCRTCSRD";
    private static final String TRACE_MASKF = "XCRTCSRF";
    private static final String TRACE_MASKT = "XCRTCSRT";
    private String country = null;
    private String state = null;
    private String locality = null;
    private String org = null;
    private String orgUnit = null;
    private String hostName = null;
    private String eMailAddr = null;
    private HashSet alternateDNSNames = null;
    private HashSet ipAddresses = null;

    CertSignReq(String country, String state, String locality, String org, String orgUnit, String hostName, String eMailAddr, HashSet alternateDNSNames, HashSet ipAddresses) {
        this.country = country;
        this.state = state;
        this.locality = locality;
        this.org = org;
        this.orgUnit = orgUnit;
        this.hostName = hostName;
        this.eMailAddr = eMailAddr;
        this.alternateDNSNames = alternateDNSNames;
        this.ipAddresses = ipAddresses;
        Trace.trace(TRACE_MASKT, "<->CertSignReq(" + country + ", " + state + ", " + locality + ", " + org + ", " + orgUnit + ", " + hostName + ", " + eMailAddr + ")");
    }

    public static void main(String[] args) {
        HashSet<String> alternateDNSNames = null;
        HashSet<String> ipAddresses = null;
        boolean selfSigned = false;
        StringBuffer argsLine = new StringBuffer();
        int i = 0;
        while (i < args.length) {
            argsLine.append(' ');
            argsLine.append(args[i]);
            ++i;
        }
        Trace.trace(TRACE_MASKD, "main() called with the following parameters :" + argsLine.toString());
        try {
            if (args.length == 1) {
                CertSignReq.view(args[0]);
            } else if (args.length == 5) {
                if (args[3].equalsIgnoreCase("true")) {
                    selfSigned = true;
                }
                CertSignReq.sign(args[0], args[1], Integer.parseInt(args[2]), selfSigned, args[4]);
            } else {
                if (args.length < INDEX_OF_LAST_FIXED_ARG) {
                    CertSignReq.displayHelp();
                    CertUtils.doExit(16);
                }
                alternateDNSNames = new HashSet<String>();
                ipAddresses = new HashSet<String>();
                int i2 = INDEX_OF_LAST_FIXED_ARG;
                while (i2 < args.length) {
                    if (CertUtils.isIPAddress(args[i2])) {
                        ipAddresses.add(args[i2]);
                    } else {
                        alternateDNSNames.add(args[i2]);
                    }
                    ++i2;
                }
                new CertSignReq(args[2], args[3], args[4], args[5], args[6], args[7], args[8], alternateDNSNames, ipAddresses).writeToFile(args[0], args[1]);
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKD, e);
            e.printStackTrace();
            CertUtils.doExit(32);
        }
        CertUtils.doExit(0);
    }

    private static void displayHelp() {
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq' csrFile serverKeyFile country state");
        System.out.println("          locality org orgUnit hostName eMailAddr");
        System.out.println("          [altDNSName | altIPAddress]...");
        System.out.println("");
        System.out.println("csrFile is the fully qualified name of the certificate signing request file to create.");
        System.out.println("serverKeyFile is the fully qualified name of the server key file to create.");
        System.out.println("country the two letter country code (e.g. US).");
        System.out.println("state the state or province (e.g. CA).");
        System.out.println("locality the locality (e.g. Los Angeles).");
        System.out.println("org the organization (e.g. IBM).");
        System.out.println("orgUnit the organization unit (e.g. HMC).");
        System.out.println("hostName the fully qualified host name of the server for which the certificate is requested.");
        System.out.println("eMailAddr the email address of ??.");
        System.out.println("altDNSName is a DNS name, other than the fully qualified host name, by which the host");
        System.out.println("  is known. The name(s) will be added to the certificate in the subjectAltName field.");
        System.out.println("altIPAddress is an IP address by which the host is known. The address(es) will be");
        System.out.println("  added to the certificate in the subjectAltName field.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq' certificateSigningRequestFileToView");
        System.out.println("");
        System.out.println("certificateSigningRequestFileToView is the fully qualified name of the certificate signing request file to view.");
        System.out.println("");
        System.out.println(" or ");
        System.out.println("");
        System.out.println("Usage : 'java' 'com.ibm.hwmca.fw.certs.CertSignReq' certificateSigningRequestFileToSign");
        System.out.println("          signingKeyFile days selfSignedOrNot resultingCertificateFile");
        System.out.println("");
        System.out.println("certificateSigningRequestFileToSign is the fully qualified name of");
        System.out.println(" the certificate signing request file to sign.");
        System.out.println("signingKeyFile is the fully qualified name of the key file used to sign");
        System.out.println(" the certificate signing request.");
        System.out.println("days the number of days to certify the certificate for.");
        System.out.println("selfSignedOrNot 'true' if self signed; anything else if not.");
        System.out.println("resultingCertificateFile is the fully qualified name of where the resulting");
        System.out.println(" certificate file will be written.");
        System.out.println("");
        System.out.println("Note, the resulting signed certificate does not automatically include subject alternative names in the certificate signing request file.");
        System.out.println("");
        System.out.println("A return code other than 0 indicates an error.");
        System.out.println("");
        System.out.println("The above command syntax above uses the following conventions:");
        System.out.println("");
        System.out.println("Literal tokens in the specified command are denoted by being enclosed in single quotes.");
        System.out.println("When specified, the single quotes should not be specified.");
        System.out.println("");
        System.out.println("Tokens that are not literal tokens should be replaced with the appropriate value.");
        System.out.println("");
        System.out.println("Tokens that are optional are enclosed in square brackets. If more than one token is");
        System.out.println("included and separated by a vertical bar, you can chose one or none of the tokens.");
        System.out.println("Neither the square brackets or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If there are multiple token choices but one is required, the tokens are enclosed in");
        System.out.println("braces and separated by a vertical bar.");
        System.out.println("Neither the braces or vertical bars should be specified on the command.");
        System.out.println("");
        System.out.println("If a token or group of tokens, grouped by square brackets or braces, can be repeated,");
        System.out.println("a sequence of three periods will follow the token or token group.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void writeToFile(String fileName, String serverKeyFile) throws HException {
        String tempPassPhrase = null;
        String csrCommand = null;
        String removePassCommand = null;
        File randomFile = null;
        String randomFileName = null;
        String[] env = null;
        String subjectAltNames = null;
        File tempDirFile = null;
        String openSSLPath = null;
        String configFile = null;
        String tempDir = null;
        try {
            openSSLPath = BaseFileControl.getFilePath("openssl");
            configFile = CertUtils.getFQFileName("CSR.cnf");
            tempDir = BaseFileControl.getFilePath("tmp");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        tempPassPhrase = String.valueOf(new Date().getTime());
        csrCommand = openSSLPath + "openssl req -new -out " + fileName + " -passout pass:" + tempPassPhrase + " -keyout " + serverKeyFile + " -config " + configFile + "";
        subjectAltNames = this.getSubjectAltNamesAsString();
        if (subjectAltNames != null && subjectAltNames.length() > 0) {
            env = new String[9];
            env[8] = "SUBJECT_ALT_NAME=" + subjectAltNames;
        } else {
            env = new String[8];
        }
        try {
            try {
                if (tempDir == null) {
                    throw new HException("Temporary directory can not be determined.");
                }
                tempDirFile = new File(tempDir);
                randomFile = File.createTempFile(TRACE_MASKT, null, tempDirFile);
                randomFileName = randomFile.getCanonicalPath();
                env[0] = "RANDOM_FILE=" + randomFile;
                env[1] = "COUNTRY=" + this.country;
                env[2] = "STATE=" + this.state;
                env[3] = "LOCALITY=" + this.locality;
                env[4] = "ORGANIZATION=" + this.org;
                env[5] = "ORGANIZATION_UNIT=" + this.orgUnit;
                env[6] = "COMMON_NAME=" + this.hostName;
                env[7] = "EMAIL_ADDRESS=" + this.eMailAddr;
                CertUtils.executeCommand(csrCommand, env);
                removePassCommand = openSSLPath + "openssl rsa -in " + serverKeyFile + " -out " + serverKeyFile + " -passin pass:" + tempPassPhrase;
                CertUtils.executeCommand(removePassCommand);
            }
            catch (IOException e) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 12, e).log();
                throw new HException(e);
            }
            Object var16_16 = null;
            if (randomFile == null) return;
            randomFile.delete();
            return;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            if (randomFile == null) throw throwable;
            randomFile.delete();
            randomFile = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sign(String keyFile, int daysToUseOnCreate, boolean isSelfSigned, String certFile) throws HException {
        block8: {
            String createCertCommand = null;
            String openSSLPath = null;
            String selfSignedConfigFile = null;
            String cASignedConfigFile = null;
            String[] env = null;
            String subjectAltNames = null;
            File tempCSRFile = null;
            String tempCSRFileName = null;
            String tempDir = null;
            try {
                selfSignedConfigFile = CertUtils.getFQFileName("selfSignedCert.cnf");
                cASignedConfigFile = CertUtils.getFQFileName("CASignedCert.cnf");
                openSSLPath = BaseFileControl.getFilePath("openssl");
                tempDir = BaseFileControl.getFilePath("tmp");
            }
            catch (HException e) {
                new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
                throw e;
            }
            subjectAltNames = this.getSubjectAltNamesAsString();
            if (subjectAltNames != null && subjectAltNames.length() > 0) {
                env = new String[]{"SUBJECT_ALT_NAME=" + subjectAltNames};
            }
            try {
                try {
                    tempCSRFile = File.createTempFile(TRACE_MASKT, null, new File(tempDir));
                    tempCSRFileName = tempCSRFile.getCanonicalPath();
                }
                catch (IOException e) {
                    new FrameworkLog(CertMgtConstants.LOG_INFO, 12, e).log();
                    throw new HException(e);
                }
                this.writeToFile(tempCSRFileName, keyFile);
                createCertCommand = openSSLPath + "openssl x509 -in " + tempCSRFileName + " -out " + certFile + " -req -signkey " + keyFile + " -days " + daysToUseOnCreate;
                createCertCommand = isSelfSigned ? createCertCommand + " -extfile " + selfSignedConfigFile + " -extensions v3_self_signed" : createCertCommand + " -extfile " + cASignedConfigFile + " -extensions v3_CA_signed";
                CertUtils.executeCommand(createCertCommand, env);
                Object var16_16 = null;
                if (tempCSRFile == null) break block8;
                tempCSRFile.delete();
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (tempCSRFile != null) {
                    tempCSRFile.delete();
                }
                throw throwable;
            }
            {
            }
        }
    }

    static void sign(String cSRFileName, String keyFile, int daysToUseOnCreate, boolean isSelfSigned, String certFile) throws HException {
        String createCertCommand = null;
        String openSSLPath = null;
        String selfSignedConfigFile = null;
        String cASignedConfigFile = null;
        try {
            selfSignedConfigFile = CertUtils.getFQFileName("selfSignedCert.cnf");
            cASignedConfigFile = CertUtils.getFQFileName("CASignedCert.cnf");
            openSSLPath = BaseFileControl.getFilePath("openssl");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        createCertCommand = openSSLPath + "openssl x509 -in " + cSRFileName + " -out " + certFile + " -req -signkey " + keyFile + " -days " + daysToUseOnCreate;
        createCertCommand = isSelfSigned ? createCertCommand + " -extfile " + selfSignedConfigFile + " -extensions v3_self_signed" : createCertCommand + " -extfile " + cASignedConfigFile + " -extensions v3_CA_signed";
        CertUtils.executeCommand(createCertCommand, null);
    }

    private static void view(String fileName) throws HException {
        String viewCommand = null;
        String openSSLPath = null;
        try {
            openSSLPath = BaseFileControl.getFilePath("openssl");
        }
        catch (HException e) {
            new FrameworkLog(CertMgtConstants.LOG_INFO, 8, e).log();
            throw e;
        }
        viewCommand = openSSLPath + "openssl req -in " + fileName + " -text";
        CertUtils.executeCommand(viewCommand);
    }

    private String getSubjectAltNamesAsString() {
        Iterator i;
        StringBuffer subjectAltNameBuf = null;
        boolean addedEntry = false;
        subjectAltNameBuf = new StringBuffer();
        if (this.alternateDNSNames != null) {
            i = this.alternateDNSNames.iterator();
            while (i.hasNext()) {
                if (addedEntry) {
                    subjectAltNameBuf.append(',');
                }
                subjectAltNameBuf.append("DNS:");
                subjectAltNameBuf.append((String)i.next());
                addedEntry = true;
            }
        }
        if (this.ipAddresses != null) {
            i = this.ipAddresses.iterator();
            while (i.hasNext()) {
                if (addedEntry) {
                    subjectAltNameBuf.append(',');
                }
                subjectAltNameBuf.append("IP:");
                subjectAltNameBuf.append((String)i.next());
                addedEntry = true;
            }
        }
        return subjectAltNameBuf.toString();
    }
}

